<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;


class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function listar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $usuario =User::all();
        return $usuario;
    }

    public function selectUsuario(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $usuarios =User::where('condicion','=','1')
        ->select('id','nombre')->orderby('nombre','asc')->get();
        return ['usuarios' => $usuarios];
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function guardar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $usuario = new User();
        $usuario -> nombre = $request -> nombre;
        $usuario -> correo = $request -> correo;
        $usuario -> password = bcrypt($request -> password);
        $usuario -> tipo = $request -> tipo;
        $usuario -> condicion = 1;
        $usuario -> rol = $request -> rol;
        $usuario -> save();

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function actualizar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $usuario = User::findOrFail($request->id);
        $usuario -> nombre = $request -> nombre;
        $usuario -> correo = $request -> correo;
        $usuario -> password = bcrypt($request -> password);
        $usuario -> condicion = 1;
        $usuario -> rol = $request -> rol;
        $usuario -> save();
    }

    public function eliminar(Request $request)
    {
    if (!$request->ajax()) return redirect('/');
    try {
        $usuario = User::findOrFail($request->id);
        $usuario->delete();
                return response()->json(['success' => 'Usuario eliminado correctamente']);
            } catch (QueryException $e) {
                if ($e->getCode() == 23000) {
                    return response()->json(['error' => 'No se puede eliminar el usuario porque tiene registros asociados.'], 400);
                }
                return response()->json(['error' => 'Error al eliminar el usuario.'], 500);
            }
    

    }






}
