<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/main', function () {
    return view('contenido/contenido');
})->name('main')->middleware('auth');

//Usuarios

Route::get('/usuario', 'UserController@listar');
Route::post('/usuario/crear', 'UserController@guardar');
Route::put('/usuario/actualizar', 'UserController@actualizar');
Route::delete('/usuario/eliminar', 'UserController@eliminar');
Route::get('/usuario/selectUsuario', 'UserController@selectUsuario');

//Casos

Route::get('/caso', 'CasoController@listar');
Route::post('/caso/crear', 'CasoController@guardar');
Route::put('/caso/actualizar', 'CasoController@actualizar');
Route::delete('/caso/eliminar', 'CasoController@eliminar')->middleware('auth');

//Login

Route::get('/', 'Auth\LoginController@loginForm');
Route::post('/login', 'Auth\LoginController@login')->name('login');

//Cerrar sesion 

Route::post('/logout', 'Auth\LoginController@logout');
Auth::routes();